#include <bits/stdc++.h>
using namespace std;

struct Node {
    int label;
    int left;
    int right;
    Node() : label(0), left(-1), right(-1) {}
    Node(int v) : label(v), left(-1), right(-1) {}
};

// Mappe per accesso rapido
unordered_map<int, int> inIndex;      // label -> index in inorder
unordered_map<int, Node> nodes;       // label -> Node

// Build from inorder + preorder
int buildFromPre(const vector<int>& inorder, const vector<int>& preorder,
                 int inL, int inR, int& preIdx) {
    if (inL > inR) return -1;

    // 1. Prendi Radice e avanza indice
    int rootVal = preorder[preIdx++];
    // 2. Trova punto di taglio in O(1)
    int mid = inIndex[rootVal];

    if (!nodes.count(rootVal)) nodes[rootVal] = Node(rootVal);

    // 3. Ricorsione Standard: SX poi DX
    int leftChild  = buildFromPre(inorder, preorder, inL, mid - 1, preIdx);
    int rightChild = buildFromPre(inorder, preorder, mid + 1, inR, preIdx);

    nodes[rootVal].left = leftChild;
    nodes[rootVal].right = rightChild;

    return rootVal;
}

// Build from inorder + postorder
int buildFromPost(const vector<int>& inorder, const vector<int>& postorder,
                  int inL, int inR, int& postIdx) {
    if (inL > inR) return -1;

    // 1. Radice è in FONDO
    int rootVal = postorder[postIdx--];
    int mid = inIndex[rootVal];

    if (!nodes.count(rootVal)) nodes[rootVal] = Node(rootVal);

    // 2. IMPORTANTE: Prima DX poi SX!
    int rightChild = buildFromPost(inorder, postorder, mid + 1, inR, postIdx);
    int leftChild  = buildFromPost(inorder, postorder, inL, mid - 1, postIdx);

    nodes[rootVal].left = leftChild;
    nodes[rootVal].right = rightChild;

    return rootVal;
}

int main() {
    ifstream fin("input.txt");
    ofstream fout("output.txt");

    if (!fin.is_open()) {
        // If input file is missing, just exit silently (or print error to cerr).
        return 0;
    }

    int N;
    fin >> N;

    int VT1, VT2;
    vector<int> seq1(N), seq2(N);

    fin >> VT1;
    for (int i = 0; i < N; ++i) fin >> seq1[i];

    fin >> VT2;
    for (int i = 0; i < N; ++i) fin >> seq2[i];

    vector<int> inorder(N), other(N);
    int otherType; // -1 = preorder, 1 = postorder

    if (VT1 == 0) {
        inorder = seq1;
        other = seq2;
        otherType = VT2;
    } else {
        inorder = seq2;
        other = seq1;
        otherType = VT1;
    }

    // Costruzione indice per l'attraversamento inorder
    inIndex.clear();
    for (int i = 0; i < N; ++i) {
        inIndex[inorder[i]] = i;
    }

    nodes.clear();
    int rootLabel = -1;

    if (otherType == -1) {
        // Preorder + inorder
        int preIdx = 0;
        rootLabel = buildFromPre(inorder, other, 0, N - 1, preIdx);
    } else if (otherType == 1) {
        // Postorder + inorder
        int postIdx = N - 1;
        rootLabel = buildFromPost(inorder, other, 0, N - 1, postIdx);
    } else {
        // L'input non rispetta le specifiche, esci.
        return 0;
    }

    // Raccogli tutte le etichette e ordinale in modo da ottenere un ordine di
    // output deterministico
    vector<int> labels;
    labels.reserve(nodes.size());
    for (const auto& p : nodes) {
        labels.push_back(p.first);
    }
    sort(labels.begin(), labels.end());

    // Output: n_i nchildren_i n_i1 ... n_ij
    for (int lbl : labels) {
        Node& node = nodes[lbl];
        vector<int> children;
        if (node.left != -1)  children.push_back(node.left);
        if (node.right != -1) children.push_back(node.right);

        fout << node.label << " " << children.size();
        for (int c : children) {
            fout << " " << c;
        }
        fout << "\n";
    }

    return 0;
}
