#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

#ifdef EVAL
ifstream in("input.txt");
ofstream out("output.txt");
#else
istream &in(cin);
ostream &out(cout);
#endif

int ceilRec(vector<int> const& A, int i, int j, int v) {
  if(i == j) {
    if(v >= A[i]) {
      return -1;
    } else {
      return A[i];
    }
  } else {
    int m = (i+j)/2;
    if(v >= A[m]) {
      return ceilRec(A, m+1, j, v);
    } else {
      return ceilRec(A, i, m, v);
    }
  }
}

int ceil(vector<int> const& A, int N, int v) {
    return ceilRec(A, 1, N, v);
}

int main() {
  int Nv, N;
  vector<int> Vs;
  vector<int> A;

  // read N, V
  in >> Nv >> N;

  // read Vs
  Vs.resize(Nv, -1);
  for(int j=0; j<Nv; j++) {
    in >> Vs[j];
  }

  // read A
  A.resize(N+1, 0);
  for(int i=1; i<=N; i++) {
    in >> A[i];
  }

  for(int j=0; j<Nv; j++) {
    int v = Vs[j];
    out << ceil(A, N, v) << " ";
  }
  out << endl;

  return 0;
}
